/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SLICSerialCommandMessage {
    private static final int HEADER_LENGTH = 16;
    private static final byte EYECATCHER = -1;
    private static final int MAX_MESSAGE_SIZE = 1024;
    private static final int INTERFACE_VERSION_OPCODE = 1;
    private static final int RAW_ECHO_OPCODE = 2;
    private static final int GET_CONNECTION_STATS_OPCODE = 3;
    private static final int RESET_CONNECTION_OPCODE = 4;
    private static final int GET_DST_INFO_OPCODE = 5;
    private static final int GET_IDE_LAN_INFO_OPCODE = 6;
    private static final int CONFIGURE_CONSOLE_OPCODE = 8;
    private static final int ACTIVATE_CONSOLE_OPCODE = 9;
    private static final int FORCE_DISCONNECT_CONSOLE_OPCODE = 10;
    private static final int DUMP_VIOSLIP_FR_OPCODE = 11;
    public static final byte GENESIS_CONSOLE_TYPE = 0;
    public static final byte TWINAX_CONSOLE_TYPE = 1;
    public static final byte DIRECT_OP_CONSOLE_TYPE = 2;
    public static final byte LAN_OP_CONSOLE_TYPE = 3;
    public static final byte HMC_OP_CONSOLE_TYPE = 4;
    private static final byte FORCE_CONSOLE_INIT = -1;
    private byte[] m_messageData;

    public static SLICSerialCommandMessage createGetInterfaceVersionRequest(int n) {
        return new SLICSerialCommandMessage(1, n, null);
    }

    public static SLICSerialCommandMessage createRawEchoRequest(int n, byte[] byArray) {
        return new SLICSerialCommandMessage(2, n, byArray);
    }

    public static SLICSerialCommandMessage createConnectionStatRequest(int n) {
        return new SLICSerialCommandMessage(3, n, null);
    }

    public static SLICSerialCommandMessage createResetConnectionRequest(int n) {
        return new SLICSerialCommandMessage(4, n, null);
    }

    public static SLICSerialCommandMessage createDSTInfoRequest(int n) {
        return new SLICSerialCommandMessage(5, n, null);
    }

    public static SLICSerialCommandMessage createIdeLanInfoRequest(int n) {
        return new SLICSerialCommandMessage(6, n, null);
    }

    public static SLICSerialCommandMessage createConfigureConsoleRequest(int n) {
        return new SLICSerialCommandMessage(8, n, null);
    }

    public static SLICSerialCommandMessage createActivateConsoleRequest(int n, boolean bl) {
        byte[] byArray = new byte[4];
        if (bl) {
            byArray[3] = -1;
            byArray[2] = -1;
            byArray[1] = -1;
            byArray[0] = -1;
        }
        return new SLICSerialCommandMessage(9, n, byArray);
    }

    public static SLICSerialCommandMessage createForceDisconnectConsoleRequest(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = -1;
        byArray[2] = -1;
        byArray[1] = -1;
        byArray[0] = -1;
        return new SLICSerialCommandMessage(10, n, byArray);
    }

    public static SLICSerialCommandMessage createDumpVIOSLIPFRRequest(int n, long l) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return new SLICSerialCommandMessage(11, n, byArray);
    }

    public SLICSerialCommandMessage(byte[] byArray, int n, int n2) {
        if (byArray == null || byArray.length < n + n2) {
            throw new IllegalArgumentException("SLICSerialCommandMessage: messageData.length is too short");
        }
        int n3 = byArray[n + 1] & 0xFF;
        if (byArray[n] != -1 || n3 > n2 || n3 < 16) {
            throw new IllegalArgumentException("SLICSerialCommandMessage: Invalid header data");
        }
        this.m_messageData = new byte[n2];
        System.arraycopy(byArray, n, this.m_messageData, 0, n2);
    }

    public SLICSerialCommandMessage(int n, int n2, byte[] byArray) {
        int n3 = byArray == null ? 0 : byArray.length;
        this.m_messageData = new byte[n3 + 16];
        this.m_messageData[0] = -1;
        this.m_messageData[1] = 16;
        this.m_messageData[2] = (byte)(0xFF & n >> 8);
        this.m_messageData[3] = (byte)(0xFF & n);
        this.m_messageData[4] = (byte)(0xFF & n2 >> 8);
        this.m_messageData[5] = (byte)(0xFF & n2);
        this.m_messageData[6] = 0;
        this.m_messageData[7] = 0;
        if (n3 > 0) {
            System.arraycopy(byArray, 0, this.m_messageData, 16, n3);
        }
    }

    public int getCorrelationToken() {
        return this.m_messageData[4] << 8 & 0xFF00 | this.m_messageData[5] & 0xFF;
    }

    public int getOpcode() {
        return this.m_messageData[2] << 8 & 0xFF00 | this.m_messageData[3] & 0xFF;
    }

    public int getReturnCode() {
        return this.m_messageData[6] << 8 & 0xFF00 | this.m_messageData[7] & 0xFF;
    }

    public byte[] getParmBytes() {
        int n = this.m_messageData[1] & 0xFF;
        if (n >= this.m_messageData.length) {
            return null;
        }
        byte[] byArray = new byte[this.m_messageData.length - n];
        System.arraycopy(this.m_messageData, n, byArray, 0, this.m_messageData.length - n);
        return byArray;
    }

    public byte[] getBytes() {
        return this.m_messageData;
    }
}

